
clear all;
close all;

%% Parameters related to experiment

% Constants
par.const.hbar = 6.62607004e-34/(2*pi);
par.const.c = 299792458;
par.const.T = 300;
par.const.kB = 1.38064852e-23;

% Parameters for mechanics
par.mech.omega = 2*pi*330e6;
par.mech.amech = 1.570496020158940e-05;
par.mech.length = 3*28;
par.mech.uc_meff = 2e-15;
par.mech.strip_meff = 2.0655e-14;
par.mech.meff = par.mech.strip_meff*par.mech.length;
par.mech.nb = par.const.kB*par.const.T/(par.const.hbar*par.mech.omega);

% Parameters for optics
par.opt.det = par.mech.omega;
par.opt.laser_power = 120e-6; % in Watts
par.opt.lambda = 1564.0562e-9;
par.opt.Qi = 163e3;
par.opt.Qe = 860e3;
par.opt.Qt = 137e3;

par.opt.omega = 2*pi*par.const.c/par.opt.lambda;
par.opt.a_in = sqrt(par.opt.laser_power/(par.const.hbar*par.opt.omega));
par.opt.Ki = par.opt.omega/par.opt.Qi;
par.opt.Ke = par.opt.omega/par.opt.Qe;
% par.opt.K = par.opt.Ki + par.opt.Ke;
par.opt.K = par.opt.omega/par.opt.Qt;
par.opt.nc = par.opt.Ke/2*par.opt.a_in^2/(par.opt.det^2 + ...
    par.opt.K^2/4);
par.opt.alpha = sqrt(par.opt.Ke/2)*par.opt.a_in/...
    (1i*par.opt.det - par.opt.K/2);

% OM and geometry parameters
% par.OM.unit_cell_g0 = 2*pi/sqrt(2)*sqrt(33^2 + 8^2)*1e3;
% par.OM.g0 = par.OM.unit_cell_g0/sqrt(par.mech.meff/par.mech.uc_meff);

%% Parameters for bulk spectrum estimation

load('../datasets/experiment_compare_data_bulk.mat');

num_freq = 5e3;

min_freq = 310e6;
max_freq = 357e6;
freq_meas = linspace(min_freq, max_freq, num_freq);
Gamma_max = 600e3;
Gamma_high_ene1 = 200e3;

% Parameters for mechanics
bulk_low = 322e6; % Edge of lower band gap
bulk_high = 344.5e6; % Edge of upper band gap

%% Select k values (depends on the size of bulk)

Nx = 1000;
% Nx = 10;
const_kx_ini = 2*pi/(Nx*geom.mech.amech)*0.5;

temp = linspace(const_kx_ini, pi/(geom.mech.amech)+const_kx_ini, Nx);

index = find(temp < pi/(geom.mech.amech));
kx = temp(index);

%% Assign g0 and frequency for each kx

[freq, g0] = get_values(data_bulk, kx, bulk_low, bulk_high);
g0 = g0/sqrt(Nx);

%% Gamma dependence on energy (assumed constant gamma for all energies)

Gamma = Gamma_max*ones(size(freq));

%% Calculating density of states

y2 = calc_SII_analytical(freq_meas, real(freq), ...
        Gamma, g0, par);
y2 = y2./(par.opt.Ke*par.opt.K/4*...
    abs(par.opt.alpha*chi_opt(freq_meas*2*pi,par) - ...
    conj(par.opt.alpha*chi_opt(-freq_meas*2*pi,par))).^2);

%% Plotting

figure(1)
hold on;
set(gca, 'FontSize', 18)
% set(gca, 'yScale', 'log')
set(gca, 'Layer', 'top');

pbaspect([5.41 1 1])

% xlim([315e6 350e6])
% shift_freq = 0;

xlim([310e6 345e6])
shift_freq = -3.523725502690544e6;

index = find(freq_meas>=310e6 & freq_meas<=345e6);
basevalue = 0;
maxvalue = 5*10^(-3);

% ylim([basevalue maxvalue])

% yticks([1e-9 1e-8])
% yticklabels({'10^{-9}','10^{-8}'})

xlabel('Frequency');
% ylabel('C S_{xx}/S_{xx,SQL}');
box on;

colour_area = [38/256, 225/256, 221/256];

% area(freq_meas+shift_freq, y2, basevalue, 'FaceColor', colour_area)
plot(freq_meas+shift_freq, y2, 'LineWidth', 2);

%% Function definitions

    function y = chi_opt(w,par)
        y = 1./(par.opt.K/2 - 1i.*(w + par.opt.det));
    end